﻿using System;

namespace Implab {
    public class FuncChainTask<TResult> : FuncChainTaskBase<TResult>, IDeferred {
        readonly Func<IPromise<TResult>> m_task;

        public FuncChainTask(Func<IPromise<TResult>> task, Func<Exception, IPromise<TResult>> error, Func<Exception, IPromise<TResult>> cancel) : base(error, cancel){
            m_task = task;
        }

        public void Resolve() {
            if (m_task != null && LockCancelation()) {
                try {
                    Observe(m_task());
                } catch (Exception err) {
                    HandleErrorInternal(err);
                }
            }
        }
    }
}