﻿using System;
using System.Threading;

namespace Implab {
    public class ActionChainTaskBase : AbstractPromise {
        readonly Func<Exception, IPromise> m_error;
        readonly Func<Exception, IPromise> m_cancel;

        int m_cancelationLock;

        protected ActionChainTaskBase( Func<Exception, IPromise> error, Func<Exception, IPromise> cancel) {
            m_error = error;
            m_cancel = cancel;
        }

        public void Reject(Exception error) {
            if (LockCancelation())
                HandleErrorInternal(error);
        }



        public override void CancelOperation(Exception reason) {
            if (m_cancel != null && LockCancelation()) {
                try {
                    Observe(m_cancel(reason));
                } catch(Exception err) {
                    HandleErrorInternal(err);
                }
            }

        }

        protected void HandleErrorInternal(Exception error) {
            if (m_error != null) {
                try {
                    Observe(m_error(error));
                } catch(Exception err) {
                    SetError(err);
                }
            } else {
                SetError(error);
            }
        }

        protected void Observe(IPromise operation) {
            if (operation == null)
                throw new NullReferenceException("The task returned null promise");

            // pass operation results to the current promise
            operation.On(SetResult, SetError, SetCancelled);

            // pass the cancelation request
            CancellationRequested(operation.Cancel);
        }

        protected bool LockCancelation() {
            return 0 == Interlocked.CompareExchange(ref m_cancelationLock, 1, 0);
        }
    }
}

