﻿using System;
using System.Threading;

namespace Implab {
    public class ActionTaskBase : AbstractPromise {
        readonly Action<Exception> m_cancel;
        readonly Action<Exception> m_error;

        int m_cancelationLock;

        protected ActionTaskBase( Action<Exception> error, Action<Exception> cancel) {
            m_error = error;
            m_cancel = cancel;
        }

        public void Reject(Exception error) {
            Safe.ArgumentNotNull(error, "error");
            if (LockCancelation())
                HandleErrorInternal(error);
        }

        protected void HandleErrorInternal(Exception error) {
            if (m_error != null) {
                try {
                    m_error(error);
                    SetResult();
                } catch(Exception err) {
                    SetError(err);
                }
            } else {
                SetError(error);
            }
        }

        public override void CancelOperation(Exception reason) {
            if (LockCancelation()) {
                if (m_cancel != null) {
                    try {
                        m_cancel(reason);
                        SetResult();
                    } catch (Exception err) {
                        HandleErrorInternal(err);
                    }
                } else {
                    SetCancelled(reason);
                }
            }
        }

        protected bool LockCancelation() {
            return 0 == Interlocked.CompareExchange(ref m_cancelationLock, 1, 0);
        }
    }
}

