using System.Xml.Serialization;

namespace Implab.ServiceHost.Unity
{
    public class ArrayParameterElement : AbstractInjectionParameter {

        [XmlAttribute("itemsType")]
        public string ItemsType { get; set; }

        [XmlElement("dependency", typeof(DependencyParameterElement))]
        [XmlElement("value", typeof(ValueParameterElement))]
        [XmlElement("serialized", typeof(SerializedParameterElement))]
        [XmlElement("default", typeof(DefaultParameterElement))]
        public AbstractInjectionParameter[] Items { get; set; }

        public override void Visit(InjectionParameterBuilder builder) {
            builder.Visit(this);
        }
    }
}