﻿using Implab.Components;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml;
using System.Xml.Serialization;

namespace Implab.Xml {
    [Obsolete("this class will be removed, use XmlDefaultSerializer")]
    public class SerializersPool<T> : ObjectPool<XmlSerializer> {

        static readonly SerializersPool<T> _instance = new SerializersPool<T>();

        public static SerializersPool<T> Instance {
            get { return _instance; }
        }

        #region implemented abstract members of ObjectPool
        protected override XmlSerializer CreateInstance() {
            return new XmlSerializer(typeof(T));
        }
        #endregion

        public T DeserializeFromString(string data) {
            using (var reader = new StringReader(data)) {
                return Deserialize(reader);
            }
        }

        public T Deserialize(TextReader reader) {
            var sr = Allocate();
            try {
                return (T)sr.Deserialize(reader);
            } finally {
                Release(sr);
            }
        }

        public T Deserialize(XmlReader reader) {
            var sr = Allocate();
            try {
                return (T)sr.Deserialize(reader);
            } finally {
                Release(sr);
            }
        }

        public string SerializeAsString(T data) {
            using (var writer = new StringWriter()) {
                Serialize(writer, data);
                return writer.ToString();
            }
        }

        public void Serialize(TextWriter writer, T data) {
            var sr = Allocate();
            try {
                sr.Serialize(writer, data);
            } finally {
                Release(sr);
            }
        }

        public void Serialize(XmlWriter writer, T data) {
            var sr = Allocate();
            try {
                sr.Serialize(writer, data);
            } finally {
                Release(sr);
            }
        }

    }
}
