using System;
using System.Xml;
using System.Xml.Schema;
using System.Xml.Serialization;

namespace Implab.ServiceHost.Unity
{
    public class SerializedParameterElement : AbstractInjectionParameter {
        [XmlAttribute("href")]
        public string Location { get; set; }

        [XmlAnyElement]
        public XmlElement[] Content { get; set; }

        public XmlReader GetReader() {
            if (!string.IsNullOrEmpty(Location))
                return XmlReader.Create(Location);
            if (Content != null && Content.Length > 0)
                return Content[0].CreateNavigator().ReadSubtree();

            throw new Exception("No content found, expected XML document");
        }

        public override void Visit(InjectionParameterBuilder builder) {
            var type = builder.ResolveInjectedValueType(TypeName);

            var serializer = new XmlSerializer(type);
            using(var reader = GetReader())
                builder.SetValue(type, serializer.Deserialize(reader));
            
        }
    }
}