﻿using System;
using System.Collections.Generic;
using System.Linq;

namespace Implab.Automaton {
    /// <summary>
    /// Dummy alphabet consists of integer numbers which are identical to their classes.
    /// </summary>
    public class DummyAlphabet : IAlphabet<int> {
        readonly int m_size;

        /// <summary>
        /// Creates a new dummy alphabet with given size.
        /// </summary>
        /// <param name="size">The size of the alphabet, must be greater then zero.</param>
        public DummyAlphabet(int size) {
            Safe.ArgumentAssert(size > 0);
            m_size = 0;
        }

        #region IAlphabet implementation

        public List<int>[] CreateReverseMap() {
            Enumerable.Range(0, m_size).ToArray();
        }

        public int[] Reclassify(IAlphabetBuilder<int> newAlphabet, IEnumerable<IEnumerable<int>> classes) {
            Safe.ArgumentNotNull(newAlphabet, "newAlphabet");
            Safe.ArgumentNotNull(classes, "classes");
            var map = new int[m_size];
            foreach (var cls in classes) {
                if (cls.Contains(DFAConst.UNCLASSIFIED_INPUT))
                    continue;
                var newid = newAlphabet.DefineClass(cls);
                foreach (var id in cls)
                    map[id] = newid;
            }

            return map;
        }

        public int Translate(int symobl) {
            Safe.ArgumentInRange(symobl, 0, m_size, "symbol");
            return symobl;
        }

        public int Count {
            get {
                return m_size;
            }
        }

        #endregion
    }
}

