﻿using System;

namespace Implab.Automaton {
    public interface IDFATableBuilder : IDFATable {
        /// <summary>
        /// Marks the state as final.
        /// </summary>
        /// <param name="state">State.</param>
        void MarkFinalState(int state);

        /// <summary>
        /// Defines the transition from <paramref name="s1"/> to
        /// <paramref name="s2"/> with input <paramref name="symbol"/>.
        /// </summary>
        /// <param name="s1">S1.</param>
        /// <param name="s2">S2.</param>
        /// <param name="symbol">Symbol.</param>
        void DefineTransition(int s1, int s2, int symbol);

        void SetInitialState(int s);

    }
}

