﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
using System.Diagnostics;

namespace Implab
{
    public static class Safe
    {
        public static void ArgumentAssert(bool condition, string paramName) {
            if (!condition)
                throw new ArgumentException("The parameter is invalid", paramName);
        }

        public static void ArgumentMatch(string value, string paramName, Regex rx) {
            if (rx == null)
                throw new ArgumentNullException("rx");
            if (!rx.IsMatch(value))
                throw new ArgumentException(String.Format("The prameter value must match {0}", rx), paramName);
        }

        public static void ArgumentNotEmpty(string value, string paramName) {
            if (String.IsNullOrEmpty(value))
                throw new ArgumentException("The parameter can't be empty", paramName);
        }

        public static void ArgumentNotEmpty<T>(T[] value, string paramName) {
            if (value == null || value.Length == 0)
                throw new ArgumentException("The array must be not emty", paramName);
        }

        public static void ArgumentNotNull(object value, string paramName) {
            if (value == null)
                throw new ArgumentNullException(paramName);
        }

        public static void ArgumentInRange(int value, int min, int max, string paramName) {
            if (value < min || value > max)
                throw new ArgumentOutOfRangeException(paramName);
        }

        public static void Dispose(params IDisposable[] objects) {
            foreach (var d in objects)
                if (d != null)
                    d.Dispose();
        }

        public static void Dispose(params object[] objects) {
            foreach (var obj in objects) {
                var d = obj as IDisposable;
                if (d != null)
                    d.Dispose();
            }
        }

        public static void Dispose(object obj) {
            var d = obj as IDisposable;
            if (d != null)
                d.Dispose();
        }

        [DebuggerStepThrough]
        public static IPromise<T> WrapPromise<T>(Func<T> action) {
            ArgumentNotNull(action, "action");

            var p = new Promise<T>();
            try {
                p.Resolve(action());
            } catch (Exception err) {
                p.Reject(err);
            }

            return p;
        }

        [DebuggerStepThrough]
        public static IPromise WrapPromise(Action action) {
            ArgumentNotNull(action, "action");

            var p = new Promise();
            try {
                action();
                p.Resolve();
            } catch (Exception err) {
                p.Reject(err);
            }

            return p;
        }

        [DebuggerStepThrough]
        public static IPromise InvokePromise(Func<IPromise> action) {
            ArgumentNotNull(action, "action");

            try {
                var p = action();
                if (p == null) {
                    var d = new Promise();
                    d.Reject(new Exception("The action returned null"));
                    p = d;
                }
                return p;
            } catch (Exception err) {
                var p = new Promise();
                p.Reject(err);
                return p;
            }
        }

        [DebuggerStepThrough]
        public static IPromise<T> InvokePromise<T>(Func<IPromise<T>> action) {
            ArgumentNotNull(action, "action");

            try {
                return action() ?? Promise<T>.FromException(new Exception("The action returned null"));
            } catch (Exception err) {
                return Promise<T>.FromException(err);
            }
        }
    }
}
