﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Implab.Diagnostics {
    public class ConsoleTraceListener: TextListenerBase {

        static readonly object _consoleLock = new object();

        public ConsoleTraceListener()
            : base(true) {

        }

        public ConsoleTraceListener(bool local)
            : base(local) {

        }

        protected override void WriteEntry(TraceContext context, EventText text) {
            var msg = new StringBuilder();

            for (int i = 0; i < text.indent; i++)
                msg.Append("  ");
            msg.AppendFormat("[{0}]: {1}", context.ThreadId, text.content);

            lock (_consoleLock) {
                Console.ForegroundColor = (ConsoleColor)(context.ThreadId % 15 + 1);
                Console.WriteLine(msg.ToString());
            }
        }
    }
}
