﻿using System.Threading;
using System;

namespace Implab {
    public class SyncContextPromise<T> : Promise<T> {
        readonly SynchronizationContext m_context;

        public SyncContextPromise(SynchronizationContext context) {
            Safe.ArgumentNotNull(context, "context");
            m_context = context;
        }

        protected override void SignalSuccess(Promise<T>.HandlerDescriptor handler) {
            m_context.Post(x => base.SignalSuccess(handler), null);
        }

        protected override void SignalError(Promise<T>.HandlerDescriptor handler, Exception error) {
            m_context.Post(x => base.SignalError(handler, error), null);
        }

        protected override void SignalCancelled(Promise<T>.HandlerDescriptor handler, Exception reason) {
            m_context.Post(x => base.SignalCancelled(handler, reason), null);
        }
    }
}

