﻿using System;

namespace Implab {
    public class ActionChainTask : ActionChainTaskBase, IDeferred {
        readonly Func<IPromise> m_task;

        public ActionChainTask(Func<IPromise> task, Func<Exception, IPromise> error, Func<Exception, IPromise> cancel) : base(error,cancel) {
            m_task = task;
        }

        public void Resolve() {
            if (m_task != null && LockCancelation()) {
                try {
                    Observe(m_task());
                } catch(Exception err) {
                    HandleErrorInternal(err);
                }
            }
        }

    }
}

