﻿using System;
using Implab.Diagnostics;
using Implab.Parallels;
using Implab;
using System.Collections.Generic;
using System.Collections.Concurrent;
using System.Threading;

namespace MonoPlay {
    class MainClass {


        public static void Main(string[] args) {
            if (args == null)
                throw new ArgumentNullException("args");

            var t1 = Environment.TickCount;

            for (int i = 0; i < 10000000; i++) {
            
                var p = new Promise<int>();
                p.On(HandleResult);
                p.Resolve(i);
            }

            var t2 = Environment.TickCount;
            Console.WriteLine("done: {0} ms, {1:.00} Mb, {2} GC", t2 - t1, GC.GetTotalMemory(false) / (1024*1024), GC.CollectionCount(0) );

        }

        static void HandleAction ()
        {
            
        }

        static void HandleResult(int x) {

        }
    }
}
