﻿using System;

namespace Implab.Automaton.RegularExpressions {
    public class CatToken<TTag> : BinaryToken<TTag> {
        public CatToken(Token<TTag> left, Token<TTag> right)
            : base(left, right) {
        }

        public override void Accept(IVisitor<TTag> visitor) {
            Safe.ArgumentNotNull(visitor, "visitor");
            visitor.Visit(this);
        }

        public override string ToString() {
            return String.Format("{0}{1}", FormatToken(Left), FormatToken(Right));
        }

        static string FormatToken(Token<TTag> token) {
            return String.Format(token is AltToken<TTag> ? "({0})" : "{0}", token);
        }
    }
}
