﻿using System;

namespace Implab.Automaton.RegularExpressions {
    public class RegularDFADefinition<TInput, TTag> : DFATransitionTable<TTag>, IDFATransitionTable<TTag> {

        readonly IAlphabet<TInput> m_alphabet;
        readonly int m_initialState;

        public RegularDFADefinition(IAlphabet<TInput> alphabet, int initialState) {
            Safe.ArgumentNotNull(alphabet, "aplhabet");

            m_alphabet = alphabet;
            m_initialState = initialState;
        }


        public IAlphabet<TInput> InputAlphabet {
            get {
                return m_alphabet;
            }
        }

        protected override DFAStateDescriptior<TTag>[] ConstructTransitionTable() {
            if (InputAlphabet.Count != m_alphabet.Count)
                throw new InvalidOperationException("The alphabet doesn't match the transition table");
            
            return base.ConstructTransitionTable();
        }

        /// <summary>
        /// Optimize the specified alphabet.
        /// </summary>
        /// <param name="alphabet">Пустой алфавит, который будет зполнен в процессе оптимизации.</param>
        public  RegularDFADefinition<TInput, TTag> Optimize(IAlphabetBuilder<TInput> alphabet) {
            Safe.ArgumentNotNull(alphabet, "alphabet");

            var optimalDFA = new RegularDFADefinition<TInput,TTag>(alphabet, m_initialState);

            Optimize(optimalDFA, InputAlphabet, alphabet, new DummyAlphabet(StateCount), new MapAlphabet<int>()); 

        }


    }
}

