﻿using System;

namespace Implab {
    public interface ICancellationToken {
        /// <summary>
        /// Indicates wherther the cancellation was requested.
        /// </summary>
        bool IsCancellationRequested { get ; }

        /// <summary>
        /// The reason why the operation should be cancelled.
        /// </summary>
        Exception CancellationReason { get ; }

        /// <summary>
        /// Accepts if requested.
        /// </summary>
        /// <returns><c>true</c>, if if requested was accepted, <c>false</c> otherwise.</returns>
        bool CancelOperationIfRequested();

        /// <summary>
        /// Sets the token to cancelled state.
        /// </summary>
        /// <param name="reason">The reason why the operation was cancelled.</param>
        void CancelOperation(Exception reason);

        /// <summary>
        /// Adds the listener for the cancellation request, is the cancellation was requested the <paramref name="handler"/>
        /// is executed immediatelly.
        /// </summary>
        /// <param name="handler">The handler which will be executed if the cancel occurs.</param>
        void CancellationRequested(Action<Exception> handler);

    }
}

