﻿using System;

namespace Implab {
    public class SuccessPromise<T> : IPromise<T> {
        readonly T m_value;

        public SuccessPromise(T value){
            m_value = value;
        }

        public IPromise<T> On(Action<T> success, Action<Exception> error, Action<Exception> cancel) {
            if (success != null) {
                try {
                    success(m_value);
                    // Analysis disable once EmptyGeneralCatchClause
                } catch {
                }
            }
            return this;
        }

        public IPromise<T> On(Action<T> success, Action<Exception> error) {
            if (success != null) {
                try {
                    success(m_value);
                    // Analysis disable once EmptyGeneralCatchClause
                } catch {
                }
            }
            return this;
        }

        public IPromise<T> On(Action<T> success) {
            if (success != null) {
                try {
                    success(m_value);
                    // Analysis disable once EmptyGeneralCatchClause
                } catch {
                }
            }
            return this;
        }

        public T Join() {
            return m_value;
        }

        public T Join(int timeout) {
            return m_value;
        }

        public IPromise<T> On(Action success, Action<Exception> error, Action<Exception> cancel) {
            if (success != null) {
                try {
                    success();
                    // Analysis disable once EmptyGeneralCatchClause
                } catch {
                }
            }
            return this;
        }

        public IPromise<T> On(Action success, Action<Exception> error) {
            if (success != null) {
                try {
                    success();
                    // Analysis disable once EmptyGeneralCatchClause
                } catch {
                }
            }
            return this;
        }

        public IPromise<T> On(Action success) {
            if (success != null) {
                try {
                    success();
                    // Analysis disable once EmptyGeneralCatchClause
                } catch {
                }
            }
            return this;
        }
            
        public IPromise<T> On(Action handler, PromiseEventType events) {
            if (handler != null && events.HasFlag(PromiseEventType.Success)) {
                try {
                    handler();
                // Analysis disable once EmptyGeneralCatchClause
                } catch {
                }
            }
            return this;
        }

        IPromise IPromise.On(Action success, Action<Exception> error, Action<Exception> cancel) {
            return On(success, error, cancel);
        }

        IPromise IPromise.On(Action success, Action<Exception> error) {
            return On(success, error);
        }

        IPromise IPromise.On(Action success) {
            return On(success);
        }

        IPromise IPromise.On(Action handler, PromiseEventType events) {
            return On(handler, events);
        }

        public IPromise<T2> Cast<T2>() {
            return new SuccessPromise<T2>((T2)(object)m_value);
        }

        void IPromise.Join() {
        }

        void IPromise.Join(int timeout) {
        }

        public Type PromiseType {
            get {
                return typeof(T);
            }
        }

        public bool IsResolved {
            get {
                return true;
            }
        }

        public bool IsCancelled {
            get {
                return false;
            }
        }

        public Exception Error {
            get {
                return null;
            }
        }

        public void Cancel() {
        }

        public void Cancel(Exception reason) {
        }
    }
}

