﻿using System;

namespace Implab {
    /// <summary>
    /// Deferred result, usually used by asynchronous services as the service part of the promise.
    /// </summary>
    public interface IResolvable {

        void Resolve();

        void Resolve(IPromise thenable);

        /// <summary>
        /// Reject the promise with the specified error.
        /// </summary>
        /// <param name="error">The reason why the promise is rejected.</param>
        /// <remarks>
        /// Some exceptions are treated in a special case: 
        /// <see cref="OperationCanceledException"/> is interpreted as call to <see cref="Cancel()"/> method,
        /// and <see cref="PromiseTransientException"/> is always unwrapped and its
        /// <see cref="PromiseTransientException.InnerException"> is used as the reason to reject promise.
        /// </remarks>
        void Reject(Exception error);
    }
}

