﻿using Implab;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Implab.Parsing {
    /// <summary>
    /// Замыкание выражения с 0 и более повторов.
    /// </summary>
    public class StarToken: Token {

        Token m_token;

        public Token Token {
            get { return m_token; }
        }

        public StarToken(Token token) {
            Safe.ArgumentNotNull(token, "token");
            m_token = token;
        }

        public override void Accept(IVisitor visitor) {
            Safe.ArgumentNotNull(visitor, "visitor");
            visitor.Visit(this);
        }

        public override string ToString() {
            return String.Format("({0})*", Token.ToString());
        }
    }
}
