using System.Xml.Serialization;

namespace Implab.ServiceHost.Unity {
    public class DependencyParameterElement : InjectionParameterElement {

        [XmlAttribute("name")]
        public string DependencyName { get; set; }

        [XmlAttribute("optional")]
        public bool Optional { get; set; }

        public override  void Visit(InjectionParameterBuilder builder) {
            var type = builder.ResolveInjectedValueType(TypeName);
            builder.SetDependency(type, DependencyName, Optional);
        }
    }
}