using Implab.Xml;
using System.Collections.Generic;
using System.Xml;
using System.Xml.Schema;
using System.Xml.Serialization;

namespace Implab.ServiceHost.Unity {
    [XmlRoot("container", Namespace = Schema.ContainerConfigurationNamespace)]
    public class ContainerElement : AbstractContainerItem {

        public List<AbstractContainerItem> Items { get; set; } = new List<AbstractContainerItem>();

        public override void Visit(ContainerBuilder context) {
            if (Items != null)
                foreach(var item in Items)
                    item.Visit(context);
        }
    }
}