﻿using Implab;

namespace Implab.Automaton.RegularExpressions {
    public abstract class BinaryToken: Token {
        readonly Token m_left;
        readonly Token m_right;

        public Token Left {
            get { return m_left; }
        }

        public Token Right {
            get { return m_right; }
        }

        protected BinaryToken(Token left, Token right) {
            Safe.ArgumentNotNull(m_left = left, "left");
            Safe.ArgumentNotNull(m_right = right, "right");
        }
    }
}
