using System;

namespace Implab
{
    public struct ResolvedPromise : IPromise {
        public Type ResultType => typeof(void);

        public bool IsResolved => true;

        public bool IsRejected => false;

        public bool IsFulfilled => true;

        public Exception RejectReason => null;

        public IPromise<T> Cast<T>() {
            throw new InvalidCastException();
        }

        public void Join() {
        }

        public void Join(int timeout) {
        }

        public void Then(IResolvable next) {
            next.Resolve();
        }
    }
}