using System;

namespace Implab.ServiceHost.Unity
{
    public class RootTypeReference : TypeReference {
        readonly string m_name;

        readonly string m_namespace;

        readonly int m_genericParametersCount;

        public override string Name {
            get { return m_name; }
        }

        public override string Namespace {
            get { return m_namespace; }
        }

        public override int GenericParametersCount {
            get { return m_genericParametersCount; }
        }

        internal RootTypeReference(string ns, string name, int genericParameters) {
            m_name = name;
            m_genericParametersCount = genericParameters;
            m_namespace = ns;
        }

        internal override void Visit(TypeResolutionContext visitor) {
            visitor.Visit(this);
        }


    }
}