using System.Collections.Generic;
using System.Threading;
using System.Threading.Tasks;

namespace Implab.Messaging {
    public interface IProducer<T> {
        void PostMessage(T message, CancellationToken ct);

        Task PostMessageAsync(T message, CancellationToken ct);

        void PostMessages(IEnumerable<T> messages, CancellationToken ct);

        Task PostMessagesAsync(IEnumerable<T> messages, CancellationToken ct);
    }
}