using System;
using System.IO;
using System.Reflection;
using System.Xml;
using System.Xml.Xsl;
using Implab.Components;
using Implab.Formats.Json;

namespace Implab.Xml {
    public class XmlToJson {
        const string XmlToJsonTransformId = "Implab.Xml.json.xsl";

        static LazyAndWeak<XslCompiledTransform> m_default = new LazyAndWeak<XslCompiledTransform>(CreateTransform, true);

        public static XslCompiledTransform Default {
            get { return m_default.Value; }
        }

        protected static XslCompiledTransform CreateTransform() {
            var transform = new XslCompiledTransform();
            using(var reader = XmlReader.Create(GetDefaultTransform())) {
                transform.Load(reader);
            }
            return transform;
        }

        protected static Stream GetDefaultTransform() {
            return Assembly.GetExecutingAssembly().GetManifestResourceStream(XmlToJsonTransformId);
        }


    }
}