﻿using System.Threading;

namespace Implab {
    public class SyncContextPromise<T> : Promise<T> {
        readonly SynchronizationContext m_context;

        public SyncContextPromise(SynchronizationContext context) {
            Safe.ArgumentNotNull(context, "context");
            m_context = context;
        }

        protected override void SignalSuccess(IDeferred<T> handler) {
            m_context.Post(x => base.SignalSuccess(handler), null);
        }

        protected override void SignalError(IDeferred<T> handler, System.Exception error) {
            m_context.Post(x => base.SignalError(handler, error), null);
        }

        protected override void SignalCancelled(IDeferred<T> handler) {
            m_context.Post(x => base.SignalCancelled(handler), null);
        }
    }
}

