﻿using System;
using Implab.Diagnostics;
using Implab.Parallels;
using Implab;
using System.Collections.Generic;
using System.Collections.Concurrent;

namespace MonoPlay {
    class MainClass {
        public static void Main(string[] args) {
            if (args == null)
                throw new ArgumentNullException("args");

            var q1 = new AsyncQueue<int>();
            var q2 = new Queue<int>();

            const int count = 10000000;


            var t1 = Environment.TickCount;

            AsyncPool.ThreadRun(
                () => {
                    for (var i = 0; i < count; i++)
                        q1.Enqueue(i);
                },
                () => {
                    for (var i = 0; i < count; i++)
                        q1.Enqueue(i);
                },
                () => {
                    int temp = 0;
                    int i = 0;
                    while (i < count)
                        if (q1.TryDequeue(out temp))
                            i++;
                },
                () => {
                    int temp = 0;
                    int i = 0;
                    while (i < count)
                        if (q1.TryDequeue(out temp))
                            i++;
                }
            )
                .Combine()
                .Join();

            var t2 = Environment.TickCount;
            Console.WriteLine("MTQueue: {0} ms", t2 - t1);

            t1 = Environment.TickCount;

            for (var i = 0; i < count * 2; i++)
                q2.Enqueue(i);

            for (var i = 0; i < count * 2; i++)
                q2.Dequeue();

            t2 = Environment.TickCount;
            Console.WriteLine("Queue: {0} ms", t2 - t1);

            q2 = new Queue<int>();

            t1 = Environment.TickCount;

         
            AsyncPool.ThreadRun(
                () => {
                    for (var i = 0; i < count; i++)
                        lock (q2)
                            q2.Enqueue(i);
                },
                () => {
                    for (var i = 0; i < count; i++)
                        lock (q2)
                            q2.Enqueue(i);
                },
                () => {
                    for (int i = 0; i < count ;)
                        lock (q2) {
                            if (q2.Count == 0)
                                continue;
                            q2.Dequeue();
                            i++;
                        }

                },
                () => {
                    for (int i = 0; i < count ;)
                        lock (q2) {
                            if (q2.Count == 0)
                                continue;
                            q2.Dequeue();
                            i++;
                        }

                }
            )
                .Combine()
                .Join();



            t2 = Environment.TickCount;
            Console.WriteLine("Queue+Lock: {0} ms", t2 - t1);

        }
    }
}
