﻿using System;

namespace Implab {
    public class ActionTask : ActionTaskBase, IDeferred {
        readonly Action m_task;
        public ActionTask(Action task, Action<Exception> error, Action<Exception> cancel, bool autoCancellable) : base(error,cancel, autoCancellable) {
            m_task = task;
        }

        public void Resolve() {
            if (m_task != null && LockCancelation()) {
                try {
                    m_task();
                    SetResult();
                } catch(OperationCanceledException reason) {
                    HandleCancelInternal(reason);
                } catch(Exception err) {
                    HandleErrorInternal(err);
                }
            }
        }
    }
}

