﻿using System;

namespace Implab.Components {
    /// <summary>
    /// Interface for the component which performs a long running task.
    /// </summary>
    /// <remarks>
    /// <para>The component also should implement <see cref="IDisposable"/> interface to be able to release used resources.</para>
    /// <para>All methods of this interface must be a thread safe. If the operation is not applicable in the current state the
    /// method should throw an exception and keep the current state unchanged.</para>
    /// </remarks>
    public interface IRunnable : IDisposable {
        /// <summary>
        /// Starts this instance
        /// </summary>
        IPromise Start();

        /// <summary>
        /// Stops this instance, after the instance is stopped it can move to Failed, Ready or Disposed state, in case with the last it can't be reused.
        /// </summary>
        IPromise Stop();

        ExecutionState State { get; }

        event EventHandler<StateChangeEventArgs> StateChanged;

        Exception LastError { get; }
    }
}

