﻿using System;
using Implab.Diagnostics;
using Implab.Parallels;
using Implab;
using System.Collections.Generic;
using System.Collections.Concurrent;

namespace MonoPlay {
    class MainClass {
        public static void Main(string[] args) {
            if (args == null)
                throw new ArgumentNullException("args");

            const int count = 10000000;

            var t1 = Environment.TickCount;

            for (int i = 0; i < count; i++) {
                var p = new Promise<int>();

                p.On(x => {}).On(x => {});

                p.Resolve(i);

            }

           

            var t2 = Environment.TickCount;
            Console.WriteLine("done: {0} ms, {1:.00} Mb, {2} GC", t2 - t1, GC.GetTotalMemory(false) / (1024*1024), GC.CollectionCount(0) );

        }
    }
}
