﻿using Implab.Formats.Json;
using Implab.Parallels;
using Implab.Xml;
using System;
using System.Collections.Concurrent;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using System.Xml;
using System.Xml.Serialization;

namespace Implab.Playground {
    public class Program {

        static void EnqueueRange<T>(ConcurrentQueue<T> q, T[] data, int offset, int len) {
            for (var i = offset; i < offset + len; i++)
                q.Enqueue(data[i]);
        }

        static bool TryDequeueRange<T>(ConcurrentQueue<T> q,T[] buffer,int offset, int len, out int actual) {
            actual = 0;
            T res;
            while(q.TryDequeue(out res)) {
                buffer[offset + actual] = res;
                actual++;
                if (actual == len)
                    break;
            }
            return actual != 0;
        }

        static void EnqueueRange<T>(SimpleAsyncQueue<T> q, T[] data, int offset, int len) {
            for (var i = offset; i < offset + len; i++)
                q.Enqueue(data[i]);
        }

        static bool TryDequeueRange<T>(SimpleAsyncQueue<T> q, T[] buffer, int offset, int len, out int actual) {
            actual = 0;
            T res;
            while (q.TryDequeue(out res)) {
                buffer[offset + actual] = res;
                actual++;
                if (actual == len)
                    break;
            }
            return actual != 0;
        }

        static void EnqueueRange<T>(AsyncQueue<T> q, T[] data, int offset, int len) {
            for (var i = offset; i < offset + len; i++)
                q.Enqueue(data[i]);
        }

        static bool TryDequeueRange<T>(AsyncQueue<T> q, T[] buffer, int offset, int len, out int actual) {
            actual = 0;
            T res;
            while (q.TryDequeue(out res)) {
                buffer[offset + actual] = res;
                actual++;
                if (actual == len)
                    break;
            }
            return actual != 0;
        }
        
        
        /*static void EnqueueRange<T>(AsyncQueue<T> q, T[] data, int offset, int len) {
            q.EnqueueRange(data, offset, len);
        }

        static bool TryDequeueRange<T>(AsyncQueue<T> q, T[] buffer, int offset, int len, out int actual) {
            return q.TryDequeueRange(buffer, offset, len, out actual);
        }*/
        

        static void Main(string[] args) {

            var t = Environment.TickCount;
            using (var reader = JsonReader.Create("e:\\citylots.json")) {
                while (reader.Read()) {
                }
            }

            Console.WriteLine($"JsonReader: {Environment.TickCount - t} ms");

            Console.WriteLine("done");
        }
    }
}
