﻿using System;

namespace Implab {
    /// <summary>
    /// Deferred result, usually used by asynchronous services as the service part of the promise.
    /// </summary>
    public interface IDeferred {

        void Resolve();

        /// <summary>
        /// Reject the promise with the specified error.
        /// </summary>
        /// <param name="error">The reason why the promise is rejected.</param>
        /// <remarks>
        /// Some exceptions are treated in a special case: 
        /// <see cref="OperationCanceledException"/> is interpreted as call to <see cref="Cancel()"/> method,
        /// and <see cref="PromiseTransientException"/> is always unwrapped and its
        /// <see cref="PromiseTransientException.InnerException"> is used as the reason to reject promise.
        /// </remarks>
        void Reject(Exception error);

        /// <summary>
        /// Marks current instance as cencelled with the specified reason.
        /// </summary>
        /// <param name="reason">The reason for the operation cancellation,
        /// if not specified the new <see cref="OperationCanceledException"> will be created</param>
        void SetCancelled(Exception reason);
    }
}

