using System;

namespace Implab {
    abstract class PromiseReaction : IResolvable {
        readonly IDispatcher m_dispatcher;

        protected PromiseReaction(IDispatcher dispatcher) {
            m_dispatcher = dispatcher;
        }

        protected abstract bool HasFulfilHandler {
            get;
        }

        protected abstract bool HasRejectHandler {
            get;
        }

        public void Reject(Exception error) {
            if (!HasRejectHandler)
                DefaultReject(error);
            else if (m_dispatcher != null)
                m_dispatcher.Enqueue(() => RejectImpl(error));
            else
                RejectImpl(error);
        }

        public void Resolve() {
            if (!HasFulfilHandler)
                DefaultResolve();
            else if (m_dispatcher != null)
                m_dispatcher.Enqueue(ResolveImpl);
            else
                ResolveImpl();
        }

        protected abstract void ResolveImpl();

        protected abstract void RejectImpl(Exception reason);

        protected abstract void DefaultResolve();

        protected abstract void DefaultReject(Exception reason);
    }
}