﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Web;

namespace Implab {
    public class Disposable : IDisposable {
        
        bool m_disposed;

        public event EventHandler Disposed;

        public bool IsDisposed {
            get { return m_disposed; }
        }

        protected void AssertNotDisposed() {
            if (m_disposed)
                throw new ObjectDisposedException(this.ToString());
        }

        protected virtual void Dispose(bool disposing) {
            if (disposing && !m_disposed) {
                m_disposed = true;
                
                EventHandler temp = Disposed;
                if (temp != null) 
                    temp(this,EventArgs.Empty);
            }
        }
        public void Dispose() {
            Dispose(true);
            GC.SuppressFinalize(this);
        }

        protected virtual void ReportObjectLeaks() {
            Trace.TraceWarning("The object is marked as disposable but isn't disposed properly: {0}", this);
        }

        ~Disposable() {
            Dispose(false);
            ReportObjectLeaks();
        }
    }
}