﻿using System;
using System.Collections.Generic;

namespace Implab.Automaton {
    public interface IDFATableBuilder : IDFATable, ICollection<AutomatonTransition> {
        /// <summary>
        /// Marks the state as final.
        /// </summary>
        /// <param name="state">State.</param>
        void MarkFinalState(int state);

        void SetInitialState(int s);

        /// <summary>
        /// Increases if needed the input alphabet size to hold the specified symbol.
        /// </summary>
        /// <remarks>
        /// <code>
        /// AlphabetSize = Math.Max(AlphabetSize, symbol + 1)
        /// </code>
        /// </remarks>
        /// <param name="symbol">Symbol.</param>
        void AddSymbol(int symbol);
    }
}

