﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Implab.Diagnostics {
    public static class Trace<T> {

        readonly static LogChannel<TraceEvent> _channel = new LogChannel<TraceEvent>(typeof(T).Name);

        public static LogChannel<TraceEvent> Channel {
            get { return _channel; }
        }
        
        /// <summary>
        /// Starts the logical operation nested to the current operation nested to the current one.
        /// </summary>
        [Conditional("TRACE")]
        public static void StartLogicalOperation() {
            TraceContext.Instance.StartLogicalOperation();

        }

        /// <summary>
        /// Starts the logical operation with the specified name, this name is usefull in logs.
        /// </summary>
        /// <param name="name">Name.</param>
        [Conditional("TRACE")]
        public static void StartLogicalOperation(string name) {
            TraceContext.Instance.StartLogicalOperation(name);
        }

        /// <summary>
        /// Ends the logical operation and restores the previous one.
        /// </summary>
        [Conditional("TRACE")]
        public static void EndLogicalOperation() {
            var op = TraceContext.Instance.EndLogicalOperation();
            LogChannel<TraceEvent>.Default.LogEvent(new TraceEvent(op, TraceEventType.OperationCompleted, String.Format("-{0} : {1}ms", op.Name, op.Duration)));
        }

        /// <summary>
        /// Writes an informational message.
        /// </summary>
        /// <param name="format">Format.</param>
        /// <param name="arguments">Arguments.</param>
        [Conditional("TRACE")]
        public static void Log(string format, params object[] arguments) {
            Channel.LogEvent(TraceEvent.Create(TraceContext.Instance.CurrentOperation, TraceEventType.Information, format, arguments));
        }

        /// <summary>
        /// Writes a warning message.
        /// </summary>
        /// <param name="format">Format.</param>
        /// <param name="arguments">Arguments.</param>
        [Conditional("TRACE")]
        public static void Warn(string format, params object[] arguments) {
            Channel.LogEvent(TraceEvent.Create(TraceContext.Instance.CurrentOperation, TraceEventType.Warning, format, arguments));
        }

        [Conditional("TRACE")]
        public static void Error(string format, params object[] arguments) {
            Channel.LogEvent(TraceEvent.Create(TraceContext.Instance.CurrentOperation, TraceEventType.Error, format, arguments));
        }

        [Conditional("TRACE")]
        public static void Error(Exception err) {
            Error("{0}", err);
        }
    }
}
