﻿using System;
using Implab.Diagnostics;
using Implab.Parallels;
using Implab;
using System.Collections.Generic;
using System.Collections.Concurrent;

namespace MonoPlay {
    class MainClass {
        public static void Main(string[] args) {
            if (args == null)
                throw new ArgumentNullException("args");

            var q1 = new MTQueue<int>();
            var q2 = new Queue<int>();

            const int count = 10000000;


            var t1 = Environment.TickCount;

            Promise<int>.CreateComposite(
                new [] {
                    AsyncPool.InvokeNewThread(() => {
                        for (var i = 0; i < count; i++)
                            q1.Enqueue(i);
                    }),
                    AsyncPool.InvokeNewThread(() => {
                        int temp = 0;
                        for(int i =0 ; i< count ; i++)
                            while(!q1.TryDequeue(out temp)){
                            }
                    })
                }
            ).Join();

            var t2 = Environment.TickCount;
            Console.WriteLine("MTQueue: {0} ms", t2 - t1);

            t1 = Environment.TickCount;

            for (var i = 0; i < count; i++)
                q2.Enqueue(i);

            t2 = Environment.TickCount;
            Console.WriteLine("LinkedList: {0} ms", t2 - t1);

            q2 = new Queue<int>();

            t1 = Environment.TickCount;

            Promise<int>.CreateComposite(
                new [] {
                    AsyncPool.InvokeNewThread(() => {
                        for (var i = 0; i < count; i++)
                            lock (q2)
                                q2.Enqueue(i);
                    }),
                    AsyncPool.InvokeNewThread(() => {
                        for(int i = 0 ; i< count ;)
                            lock(q2) {
                                if(q2.Count == 0)
                                    continue;
                                q2.Dequeue();
                                i++;
                            }

                    })
                }
            ).Join();



            t2 = Environment.TickCount;
            Console.WriteLine("LinkedList+Lock: {0} ms", t2 - t1);

        }
    }
}
