﻿using System;

namespace Implab {
    public interface IPromise<out T> : IPromise {

        IPromise<T> On(Action<T> success, Action<Exception> error, Action<Exception> cancel);
        
        IPromise<T> On(Action<T> success, Action<Exception> error);

        IPromise<T> On(Action<T> success);

        new T Join();

        new T Join(int timeout);

        new IPromise<T> On(Action success, Action<Exception> error, Action<Exception> cancel);

        new IPromise<T> On(Action success, Action<Exception> error);

        new IPromise<T> On(Action success);

        new IPromise<T> On(Action handler, PromiseEventType events);

    }
}
