using System;
using System.Collections.Generic;
using System.Xml;
using System.Xml.Serialization;

namespace Implab.ServiceHost.Unity {
    public class SerializedElement : AbstractRegistration, IInstanceRegistration {
        [XmlAttribute("href")]
        public string Location { get; set; }

        [XmlAttribute("serializedType")]
        public string SerializedType { get; set; }


        [XmlAnyElement]
        public XmlElement[] Content { get; set; }

        public IEnumerable<IInjectionParameter> MemberInjections {
            get {
                yield return new SerializedParameterElement {
                    TypeName = SerializedType,
                    Location = Location,
                    Content = Content
                };
            }
        }

        public override void Visit(ContainerBuilder builder) {
            builder.Visit(this);
        }
    }
}