using System;
using System.Text;

namespace Implab.ServiceHost.Unity {
    public class NestedTypeReference : TypeReference {

        readonly string m_name;

        readonly int m_genericParametersCount;

        public TypeReference DeclaringType { get; private set; }

        public override string Name {
            get {
                return m_name;
            }
        }

        public override string Namespace {
            get {
                return DeclaringType.Namespace;
            }
        }

        public override int GenericParametersCount {
            get {
                return m_genericParametersCount;
            }
        }

        internal NestedTypeReference(TypeReference declaringType, string name, int parametersCount) {
            DeclaringType = declaringType;
            m_name = name;
            m_genericParametersCount = parametersCount;
        }

        internal override void Visit(TypeResolutionContext visitor) {
            visitor.Visit(this);
        }

        internal override void WriteTypeName(StringBuilder builder) {
            builder
                .Append(DeclaringType)
                .Append('+')
                .Append(Name);
        }
    }
}