﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using Implab.Components;
using Implab.Diagnostics;
using Implab.ServiceHost.Unity;
using Implab.Xml;
using Unity;
using Unity.Injection;
using Unity.Registration;

namespace Implab.Playground {

    public class Foo {

        public class Bar {

        }

        public string Name { get; set; }

        public int IntValue { get; set; }

        public string StringValue { get; set; }

        public void AddRange(Foo[] items) {
            Console.WriteLine($"AddRange: Foo[]");
        }

    }

    public class FooFactory : IFactory<Foo>, IFactory<Foo.Bar> {

        public bool UseSsl { get; set; }

        public string Connection { get; set; }
        
        public Foo Create() {
            return new Foo() {
                Name = "AutoFac"
            };
        }

        Foo.Bar IFactory<Foo.Bar>.Create() {
            return new Foo.Bar(); 
        }
    }

    public interface IContainer<T> {
        T Instance { get; set; }
    }

    public class Container<T> : IContainer<T> {
        public class Bar {

        }

        public class Bar<T2> {
            public class Baz {

            }

        }

        public Container() {

        }

        public Container(T instance) {
            Instance = instance;
        }

        public T Instance { get; set; }

        public void SetInstance(T value) {
            Instance = value;
        }

        public void AddRange(List<T> items) {
            Console.WriteLine($"AddRange: {typeof(List<T>)}");
        }

        public void AddRange(T[] items) {
            Console.WriteLine($"AddRange: T[] ofType {typeof(T[])}");
        }
    }

    public class Program {

        static void Main(string[] args) {
            var u1 = new Uri("/some/one");

            Console.WriteLine($"{u1.IsAbsoluteUri}: {u1}");

            var u2 = new Uri(u1, "../../two");

            Console.WriteLine($"{u2.IsAbsoluteUri}: {u2}");

        }

        static void Main2(string[] args) {
            var listener = new SimpleTraceListener(Console.Out);
            var source = Trace<TypeResolver>.TraceSource;
            source.Switch.Level = SourceLevels.All;
            source.Listeners.Add(listener);

            var stopwatch = new Stopwatch();
            stopwatch.Start();

            var container = new UnityContainer();

            Console.WriteLine($"Created: {stopwatch.ElapsedMilliseconds}");
            stopwatch.Restart();
            
            container.LoadXmlConfiguration("data/sample.xml");

            Console.WriteLine($"Loaded: {stopwatch.ElapsedMilliseconds}");

            stopwatch.Restart();
            var instace1 = container.Resolve<IContainer<string>>();
            Console.WriteLine($"Resolved1: {stopwatch.ElapsedMilliseconds}");

            stopwatch.Restart();
            var instace2 = container.Resolve<IContainer<Foo>>();
            Console.WriteLine($"Resolved2: {stopwatch.ElapsedMilliseconds}");

            DisplayContainerRegistrations(container);
        }

        static void DisplayContainerRegistrations(IUnityContainer theContainer) {
            string regName, regType, mapTo, lifetime;
            Console.WriteLine("Container has {0} Registrations:",
                    theContainer.Registrations.Count());
            foreach (ContainerRegistration item in theContainer.Registrations) {
                regType = item.RegisteredType.FullName;
                mapTo = item.MappedToType.FullName;
                regName = item.Name ?? "[default]";
                lifetime = item.LifetimeManager.LifetimeType.Name;
                if (mapTo != regType) {
                    mapTo = " -> " + mapTo;
                } else {
                    mapTo = string.Empty;
                }
                lifetime = lifetime.Substring(0, lifetime.Length - "LifetimeManager".Length);
                Console.WriteLine("+ {0}{1}  '{2}'  {3}", regType, mapTo, regName, lifetime);
            }
        }


    }
}
