using System;
using System.Linq;
using System.Text;

namespace Implab.ServiceHost.Unity {
    public class SpecializedTypeReference : TypeReference {
        public override string Name {
            get {
                return GenericType.Name;
            }
        }

        public override string Namespace {
            get {
                return GenericType.Namespace;
            }
        }

        public override int GenericParametersCount {
            get {
                return GenericParameters.Length;
            }
        }

        public TypeReference GenericType { get; private set; }

        public TypeReference[] GenericParameters { get; private set; }

        internal SpecializedTypeReference(TypeReference genericType, TypeReference[] genericParameters) {
            GenericType = genericType;
            GenericParameters = genericParameters;
        }

        internal override void Visit(TypeResolutionContext visitor) {
            visitor.Visit(this);
        }

        internal override void WriteTypeName(StringBuilder builder) {
            GenericType.WriteTypeName(builder);
        }

        internal override void WriteTypeParams(StringBuilder builder) {
            builder.Append('{');
            for (var i = 0; i < GenericParameters.Length; i++) {
                if (i > 0)
                    builder.Append(',');
                builder.Append(GenericParameters[i]);
            }
            builder.Append('}');
        }
    }
}