using System.Collections.Generic;
using System.Xml.Serialization;

namespace Implab.ServiceHost.Unity {
    public class ValueElement : AbstractRegistration, IInstanceRegistration {

        [XmlAttribute("value")]
        public string Value { get; set; }

        [XmlText]
        public string Text { get; set; }

        string GetTextValue() {
            return string.IsNullOrEmpty(Value) ? Text : Value;
        }

        public string TypeName {
            get {
                return RegistrationType;
            }
        }

        public IEnumerable<IInjectionParameter> MemberInjections {
            get {
                yield return new ValueParameterElement {
                    Value = Value,
                    Text = Text
                };
            }
        }

        public override void Visit(ContainerBuilder builder) {
            builder.Visit(this);
        }
    }
}