using System;
using System.Diagnostics;

namespace Implab.Diagnostics {
    public class ActivityScope : IDisposable {
        readonly TraceSource m_source;

        readonly Guid m_prevId;

        readonly string m_activity;

        readonly int m_code;

        internal ActivityScope(TraceSource source, Guid prevId, int code, string activity) {
            m_source = source;
            m_prevId = prevId;
            m_code = code;
            m_activity = activity;
        }


        public void Dispose() {
            if (Trace.CorrelationManager.ActivityId != m_prevId)
                m_source.TraceTransfer(m_code, "Transfer", m_prevId);
            m_source.TraceEvent(TraceEventType.Stop, 0, m_activity);
            Trace.CorrelationManager.ActivityId = m_prevId;
        }
    }
}