using System;
using System.Diagnostics;

namespace Implab.Diagnostics {
    public class LogicalOperationScope : IDisposable {
        readonly TraceSource m_source;

        readonly LogicalOperation m_operation;

        internal LogicalOperationScope(TraceSource source, LogicalOperation operation) {
            m_source = source;
            m_operation = operation;
        }

        public void Dispose() {
            m_operation.OperationStopwatch.Stop();
            Trace.CorrelationManager.StopLogicalOperation();
            m_source.TraceData(TraceEventType.Information, TraceEventCodes.StopLogicalOperation, m_operation);
        }
    }
}