using System;
using System.Threading.Tasks;

namespace Implab {
    public static class TaskHelpers {

        public static async Task Then(this Task that, Action fulfilled, Action<Exception> rejected) {
            Safe.ArgumentNotNull(that, nameof(that));
            if (rejected != null) {
                try {
                    await that;
                } catch (Exception e) {
                    rejected(e);
                    return;
                }
            } else {
                await that;
            }

            if (fulfilled != null)
                fulfilled();
        }

        public static async Task Then(this Task that, Action fulfilled) {
            Safe.ArgumentNotNull(that, nameof(that));
            await that;
            if (fulfilled != null)
                fulfilled();
        }

        public static async Task Then(this Task that, Func<Task> fulfilled) {
            Safe.ArgumentNotNull(that, nameof(that));
            await that;
            if (fulfilled != null)
                await fulfilled();
        }

        public static async Task Finally(this Task that, Action handler) {
            Safe.ArgumentNotNull(that, nameof(that));
            try {
                await that;
            } finally {
                if (handler != null)
                    handler();
            }
        }

        public static async void Then(this Task that, IResolvable next) {
            try {
                await that;
            } catch (Exception e) {
                next.Reject(e);
                return;
            }
            next.Resolve();
        }

        public static async void Then<T>(this Task<T> that, IResolvable<T> next) {
            T result;
            try {
                result = await that;
            } catch (Exception e) {
                next.Reject(e);
                return;
            }
            next.Resolve(result);
        }

    }
}