using System.Xml.Serialization;
using Implab.Components;

namespace Implab.Xml {
    /// <summary>
    /// This class used to get default serializer for the specified type <typeparamref name="T"/>.
    /// </summary>
    /// <typeparam name="T">The type used to create <see cref="XmlSerializer"/></typeparam>
    public static class XmlDefaultSerializer<T> {
        static readonly LazyAndWeak<XmlSerializer> m_instance = new LazyAndWeak<XmlSerializer>(() => new XmlSerializer(typeof(T)));

        public static XmlSerializer Instance { get { return m_instance.Value; } }
    }
}