using System;
using System.Text;

namespace Implab.ServiceHost.Unity {
    public class ArrayTypeReference : TypeReference {
        public int Rank { get; private set; }

        public TypeReference ItemsType { get; private set; }

        public override string Name {
            get {
                return ItemsType.Name;
            }
        }

        public override string ClrName {
            get {
                return new StringBuilder()
                    .Append(ItemsType.ClrName)
                    .Append("[")
                    .Append(',', Rank - 1)
                    .Append("]")
                    .ToString();
            }
        }

        public override string Namespace {
            get {
                return ItemsType.Namespace;
            }
        }

        public override int GenericParametersCount {
            get {
                return 0;
            }
        }

        internal ArrayTypeReference(TypeReference itemsType, int rank) {
            ItemsType = itemsType;
            Rank = rank;
        }

        internal override void Visit(TypeResolutionContext visitor) {
            visitor.Visit(this);
        }

        override public string ToString() {
            return new StringBuilder()
                .Append(ItemsType.ToString())
                .Append('[')
                .Append(',', Rank - 1)
                .Append(']')
                .ToString();
        }
    }
}