using System;
using System.Collections.Generic;
using System.Reflection;
using Implab.Components;
using Unity;
using Unity.Injection;
using Unity.Lifetime;

namespace Implab.ServiceHost.Unity {
    public class FactoryActivator : ITypeRegistration {

        class FactoryInjector : ITypeMemberInjection {
            public InjectionFactory Factory { get; set; }
            public void Visit(TypeRegistrationBuilder builder) {
                builder.AddInjectionMember(Factory);
            }
        }


        public Type FactoryType { get; set; }

        public string FactoryName { get; set; }

        public Type RegistrationType { get; set; }

        public LifetimeManager Lifetime { get; set; }

        public IEnumerable<ITypeMemberInjection> MemberInjections {
            get {
                yield return new FactoryInjector {
                    Factory = (InjectionFactory)GetType()
                        .GetMethod(nameof(CreateInjectionFactory), BindingFlags.Static | BindingFlags.NonPublic)
                        .MakeGenericMethod(FactoryType, RegistrationType)
                        .Invoke(null, new [] { FactoryName })
                };
            }
        }

        public string Name { get; set; }

        public Type GetRegistrationType(ContainerBuilder builder) {
            return RegistrationType;
        }

        public LifetimeManager GetLifetime(ContainerBuilder builder) {
            return Lifetime;
        }

        public Type GetImplementationType(ContainerBuilder builder) {
            return null;
        }

        /// <summary>
        /// Указывает зависимость, реализующую интерфейс <see cref="IFactory{TObj}"/>,
        /// которая будет использоваться в качестве фабрики для создания объектов
        /// </summary>
        /// <param name="dependencyName"></param>
        static InjectionFactory CreateInjectionFactory<TFac, TObj>(string dependencyName) where TFac : IFactory<TObj> {
            
            return new InjectionFactory(c => c.Resolve<TFac>(dependencyName).Create());
        }
    }
}